// Split from main file 23/11/2023


////////////////////////////////////////////////////////
// EHIS w2 prep on older sample: dropping missing values, create dis vars
////////////////////////////////////////////////////////

use "${EHIS}\EHIS wave 2\0_w2cleaned ${versno}.dta", replace
	global allIRTbinary		= subinstr("${allIRTbinary}", "cd1pR "    , "", .)		// not available for EHIS w2
	global agerange			"inrange(age,9,12)"		
	global countrywaves		`"inlist(countrynum,1,6,27,22,24,10,17,12,7,9,2,5,28,8,30) & !inlist(country,"BE","NL","ES")"'	// ES missing PHQgroup || BE & NL missing several key variables - PHQgroup, pl5R, pl6and7R (and for BE, pl4R)
	global whichversions	"IRT L allIRT L predfxd L"		// around cut-points, this says whether to use just below a percentile or just above (to get as close to observed LLSI as possible)
do "${dodir}\4_dis_weights.do"
	estimates clear
	save "${EHIS}\EHIS wave 2\0_w2cleaned ${versno}_vsSHARE.dta", replace


////////////////////////////////////////////////////////
// Merging with ELSA-SHARE
////////////////////////////////////////////////////////

use "${EHIS}\EHIS wave 2\0_w2cleaned ${versno}_vsSHARE.dta", replace

* File locations, copied from other file
local workingdata	"C:\Users\benba\Datasets Misc\Global Aging Data - HRS\0_BBG_working_files"									
local versno 		"v4_0"							
* Appending the data
preserve
	use "`workingdata'\HRS-SHARE-ELSA_BBG_`versno'_forEHIS.dta", replace
	rename llsiH				${disvar}
	rename llsiH_IRT			${IRTvar} 
	rename llsiH_predicted		${predictedvar}
	rename llsiH_predicted_fxd	${predictedvar}_fxd 
	rename rworknew 			${empvar}
	rename rwtresp2				${pweight}
	* Not used: global allIRTvar			"${disvar}_allfactor1"
	recode ragey (50/54=9)(55/59=10)(60/64=11)(65/69=12)(else=.), gen(age)
	recode rmale (0=2 "2_female")(1=1 "1_male"), gen(sex)
	recode country (11=1)(12=6)(13=27)(16=17)(17=12)(18=7)(19=9)(28=5)(29=24)(34=28)(35=8)(61=30)(else=.), gen(${countryvar})
	ren country elsacountry
	keep ${disvar}* ${empvar} ${pweight} ${countryvar} elsacountry age sex
	keep if !missing(age) & !missing(${countryvar})
	tempfile comparable_SHARE
	save "`comparable_SHARE'", replace
restore
append using "`comparable_SHARE'", gen(elsashare)
	label define elsashare 0 "EHIS" 1 "ELSA-SHARE"
	label values elsashare elsashare
* Setting the weights to be the same type, and to average the same value within each country
levelsof(countrynum)
foreach country in `r(levels)'	{
	local thislab: label (countrynum) `country'
	dis "For value `country', which is country `thislab'"
	* ELSA-SHARE-HRS uses probability weights (EHIS uses frequency weights I think)
	sum ${pweight} 									if elsashare==1 & countrynum==`country'
	local pweight_to_copy = `r(mean)'
	* Then replacing weights in EHIS to match
	sum ${pweight} 														if elsashare==0 & countrynum==`country'
	replace ${pweight} = ${pweight} / `r(mean)' * `pweight_to_copy'		if elsashare==0 & countrynum==`country'
	bysort elsashare: sum ${pweight} 									if 				  countrynum==`country'
/**/							}
svyset [pw=${pweight}]	


////////////////////////////////////////////////////////
// Non-bootstrap models
////////////////////////////////////////////////////////

global controlsmeans ""					// Calculating mean of controls2 variables - can't be done when setting the globals, as it depends on the analysis dataset
	svy: mean ${controls} ${controls2}		// now includes age, rather than European standard pop - see note in 0_globals.do
	if _rc==0	{							// ${controlsmeans} should be empty where ${controls2} is empty
		foreach word in `e(varlist)'	{
			local col = `col' + 1
			local working = e(b)[1, `col']
			global controlsmeans "${controlsmeans} `word'=`working'"
		/**/							}
	/**/		}
do "${dodir}\5_EHISandSHARE_nonbootstrap.do"				
